#include "datetime.h"

#include <QDateTime>
#include <QTimer>

DateTime::DateTime(QObject* parent)
    : QObject(parent)
    , m_dateTime(new QDateTime)
    , m_timer(new QTimer(this))
{
    m_dateTime = new QDateTime;
    m_timer->setSingleShot(false);
    m_timer->setInterval(1000);
    connect(m_timer, &QTimer::timeout, this, [this] {
        setCurrentTime(m_dateTime->currentDateTime().toOffsetFromUtc(m_utcOffset * 3600).toString(QStringLiteral("hh:mm:ss AP")));
        setCurrentDate(m_dateTime->currentDateTime().toOffsetFromUtc(m_utcOffset * 3600).toString(QStringLiteral("MMMM d, yyyy")));
    });

    m_timer->start();
}

void DateTime::setCurrentTime(const QString& currentTime)
{
    if (m_currentTime == currentTime)
        return;

    m_currentTime = currentTime;
    emit currentTimeChanged();
}

void DateTime::setCurrentDate(const QString& currentDate)
{
    if (m_currentDate == currentDate)
        return;

    m_currentDate = currentDate;
    emit currentDateChanged();
}

void DateTime::setUtcOffset(int offset)
{
    if ((offset > 12) || (offset < -12) || (offset == m_utcOffset))
        return;

    m_utcOffset = offset;
    emit utcOffsetChanged();
}
